package gov.va.med.mhv.bluebutton;

import gov.va.med.mhv.bluebutton.transfer.StudyDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

@Path("/")
@Service("study")
public interface StudyBusinessService {

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("study/{patientId}")
	public List<StudyDTO> getStudies(@PathParam("patientId") Long patientId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("radiology/phr/{patientId}")
	public List<StudyDTO> getPhrRadiologyAsStudy(@PathParam("patientId") Long patientId) throws MHVException;
	
}
